
//
// To jest przykadowy kod z podrozdziau 24.5.1 Wymiary i dostp ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include "Matrix.h"

using namespace std;
using namespace Numeric_lib;

//------------------------------------------------------------------------------

void f(int n1, int n2, int n3)
{
    Matrix<double,1> ad1(n1);       // Elementy s typu double; jeden wymiar.
    Matrix<int,1>    ai1(n1);       // Elementy s typu int; jeden wymiar.
    ad1(7) = 0;                     // Indeksowanie za pomoc operatora ( )  styl jzyka Fortran.
    ad1[7] = 8;                     // Operator [ ] te dziaa  styl jzyka C.

    Matrix<double,2> ad2(n1,n2);    // dwa wymiary
    Matrix<double,3> ad3(n1,n2,n3); // trzy wymiary
    ad2(3,4)   = 7.5;               // prawdziwe wielowymiarowe indeksowanie
    ad3(3,4,5) = 9.2;
}

//------------------------------------------------------------------------------

void f1(int n1, int n2, int n3)
{
    //Matrix<int,0> ai0;            // Bd: nie ma macierzy 0-wymiarowych.

    Matrix<double,1> ad1(5);
    Matrix<int,1>    ai(5);
    Matrix<double,1> ad11(7); 

    ad1(7) = 0;                     // Wyjtek Matrix_error (7 jest poza zakresem).
    //ad1 = ai;                     // Bd: rne typy elementw.
    ad1 = ad11;                     // Wyjtek Matrix_error (rne wymiary).

    //Matrix<double,2>  ad2(n1);    // Bd: nie podano rozmiaru drugiego wymiaru.
    //ad2(3) = 7.5;                 // Bd: nieprawidowa liczba indeksw.
    //ad2(1,2,3) = 7.5;             // Bd: nieprawidowa liczba indeksw.

    Matrix<double,3> ad3(n1,n2,n3);
    Matrix<double,3> ad33(n1,n2,n3);
    ad3 = ad33;                     // Dobrze: ten sam typ elementw, taka sama liczba wymiarw.
}

//------------------------------------------------------------------------------

void init(Matrix<int,2>& a) // Inicjacja kadego elementu charakterystyczn wartoci.
{
    for (int i=0; i<a.dim1(); ++i)
        for (int j = 0; j<a.dim2(); ++j)
            a(i,j) = 10*i+j;
}

//------------------------------------------------------------------------------

void print(const Matrix<int,2>& a)  // Drukuje elementy wiersz po wierszu.
{
    for (int i=0; i<a.dim1(); ++i) {
        for (int j = 0; j<a.dim2(); ++j)
            cout << a(i,j) <<'\t';
        cout << '\n';
    }
}

//------------------------------------------------------------------------------

//void init(Matrix& a);  // Bd: brakuje typu elementw i liczby wymiarw.

//------------------------------------------------------------------------------

int main()
try
{
    Matrix<int,2> a(4,3);
    init(a);
    print(a);
    f1(10, 20, 30);
    f(10, 20, 30);
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
